from tkinter import *
from tkinter import ttk, font, filedialog as fd
import shutil, os, ctypes, pyglet
from fractions import Fraction
from PIL import ImageTk, Image, ImageOps, ImageDraw, ImageFont
import Program
import MyPantry
from Ingredient import Ingredient

class Edit_ingredient(Frame):
    """
    Purpose:
        Frame to edit an ingredients cost
    Instance variables:
        self.current_ingredient: string of ingredient name that is currently
            being displayed
        self.top_frame: frame displaying label with text of
            "Cost of ....." and an entry with the cost of the ingredient
        self.edit_label: label displaying the text of cost of ingredient
        self.cost_text_box: entry box containing the cost of the ingredient
        self.middle_frame: frame containing the done and cancel buttons
        self.cancel_button: button that cancels edit and returns to my pantry frame
        self.done_button: edits the price of the ingredient and returns
            to my pantry frame
    Methods:
        update_frame: changes label and cost box to be set to a specific ingredient
        done_button_clicked: handles changing the price and returning to my pantry
            frame
    """

    def __init__(self, parent):
        self.current_ingredient = ""
        Frame.__init__(self, parent)
        self.top_frame = Frame(self)
        self.top_frame.pack()

        self.edit_label = Label(self.top_frame, text=f"Cost of Ingredient per item: $")
        self.edit_label.grid(row=0, column=0)

        self.cost_text_box = Entry(self.top_frame, width=6)
        self.cost_text_box.bind(
            "<KeyPress>",
            lambda event: Program.Program.only_allow_num_and_equations(event),
        )
        self.cost_text_box.grid(row=0, column=1)

        self.middle_frame = Frame(self)
        self.middle_frame.pack()

        self.cancel_button = Button(
            self.middle_frame,
            text="Cancel",
            command=lambda: Program.Program.controller.change_frames(MyPantry.MyPantry),
        )
        self.cancel_button.grid(row=0, column=0, padx=5)

        self.done_button = Button(
            self.middle_frame,
            text="Done",
            command=lambda: self.done_button_clicked(),
        )
        self.done_button.grid(row=0, column=1, padx=5)

    def update_frame(self, ingredient):
        self.edit_label[
            "text"
        ] = f"Cost of {ingredient} per {Ingredient.ingredients_dict[ingredient].unit}: $"
        self.cost_text_box.delete(0, "end")
        self.cost_text_box.insert(0, str(Ingredient.ingredients_dict[ingredient].cost))
        self.current_ingredient = ingredient
        Program.Program.controller.change_frames(Edit_ingredient)

    def done_button_clicked(self):
        ingredient = Program.Program.search_ingredient_name(self.current_ingredient)
        ingredient.cost = Program.Program.convert_string_to_float(self.cost_text_box.get())
        ingredient.update_recipes_cost()
        Program.Program.save(
            ingredients_save_file="ingredients.csv", recipe_save_file="recipes.csv"
        )
        Program.Program.controller.change_frames(MyPantry.MyPantry)

    def change_colors(self, bg_color, primary_color, primary_variant, secondary_color):
        elevation_1_color = Program.Program.convert_rgb_to_hex(
            Program.Program.overlay_colors(
                Program.Program.convert_hex_to_rgb(bg_color), (255, 255, 255), 0.05
            )
        )
        if Program.Program.light_mode:
            button_text_color = "#FFFFFF"
            label_color = Program.Program.convert_rgb_to_hex(
                Program.Program.overlay_colors(
                    Program.Program.convert_hex_to_rgb(elevation_1_color), (0, 0, 0), 0.87
                )
            )
        else:
            button_text_color = "#000000"
            label_color = Program.Program.convert_rgb_to_hex(
                Program.Program.overlay_colors(
                    Program.Program.convert_hex_to_rgb(elevation_1_color), (255, 255, 255), 0.87
                )
            )
        self.config(bg=bg_color)
        self.edit_label.config(bg=elevation_1_color, fg=label_color)
        self.cost_text_box.config(
            bg=elevation_1_color, insertbackground=label_color, fg=label_color
        )
        self.middle_frame.config(bg=bg_color)
        self.cancel_button_image = Program.Program.create_rounded_button_image(
            bg_color,
            primary_color,
            Program.Program.convert_rgb_to_hex(
                Program.Program.overlay_colors(
                    Program.Program.convert_hex_to_rgb(primary_color),
                    Program.Program.convert_hex_to_rgb(button_text_color),
                    0.87,
                )
            ),
            "Cancel",
            self.cancel_button.winfo_width(),
            self.cancel_button.winfo_height(),
            22,
        )
        self.cancel_button.config(
            border="0",
            relief="flat",
            borderwidth=0,
            highlightthickness=0,
            activebackground=bg_color,
            image=self.cancel_button_image,
        )
        self.done_button_image = Program.Program.create_rounded_button_image(
            bg_color,
            primary_color,
            Program.Program.convert_rgb_to_hex(
                Program.Program.overlay_colors(
                    Program.Program.convert_hex_to_rgb(primary_color),
                    Program.Program.convert_hex_to_rgb(button_text_color),
                    0.87,
                )
            ),
            "Done",
            self.done_button.winfo_width(),
            self.done_button.winfo_height(),
            22,
        )
        self.done_button.config(
            border="0",
            relief="flat",
            borderwidth=0,
            highlightthickness=0,
            activebackground=bg_color,
            image=self.done_button_image,
        )